/*
 * Decompiled with CFR 0.152.
 */
package ocr;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import ocr.ImageDeskew;

public class ImageUtils {
    public static int BLACK_PIX_VALUE = -16777216;
    public static int WHITE_PIX_VALUE = -1;
    private static final double MINIMUM_DESKEW_THRESHOLD = 0.05;

    public static BufferedImage readImageFile(File imageFile) throws IOException {
        return ImageIO.read(imageFile);
    }

    public static boolean isBlack(BufferedImage image, int x, int y) {
        if (image.getType() == 12) {
            WritableRaster raster = image.getRaster();
            int pixelRGBValue = raster.getSample(x, y, 0);
            return pixelRGBValue == 0;
        }
        int luminanceValue = 140;
        return ImageUtils.isBlack(image, x, y, luminanceValue);
    }

    public static boolean isBlack(BufferedImage image, int x, int y, int luminanceCutOff) {
        double luminance = 0.0;
        if (x < 0 || y < 0 || x > image.getWidth() || y > image.getHeight()) {
            return false;
        }
        try {
            int pixelRGBValue = image.getRGB(x, y);
            int r = pixelRGBValue >> 16 & 0xFF;
            int g = pixelRGBValue >> 8 & 0xFF;
            int b = pixelRGBValue >> 0 & 0xFF;
            luminance = (double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114;
        }
        catch (Exception e) {
            // empty catch block
        }
        return luminance < (double)luminanceCutOff;
    }

    public static BufferedImage rotate(BufferedImage image, double angle, int cx, int cy) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int maxY = 0;
        int maxX = 0;
        int minY = 0;
        int minX = 0;
        int[] corners = new int[]{0, 0, width, 0, width, height, 0, height};
        double theta = Math.toRadians(angle);
        for (int i = 0; i < corners.length; i += 2) {
            int x = (int)(Math.cos(theta) * (double)(corners[i] - cx) - Math.sin(theta) * (double)(corners[i + 1] - cy) + (double)cx);
            int y = (int)(Math.sin(theta) * (double)(corners[i] - cx) + Math.cos(theta) * (double)(corners[i + 1] - cy) + (double)cy);
            if (x > maxX) {
                maxX = x;
            }
            if (x < minX) {
                minX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (y >= minY) continue;
            minY = y;
        }
        cx -= minX;
        cy -= minY;
        BufferedImage bi = new BufferedImage(maxX - minX, maxY - minY, image.getType());
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setBackground(Color.white);
        g2.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        AffineTransform at = new AffineTransform();
        at.rotate(theta, cx, cy);
        g2.setTransform(at);
        g2.drawImage((Image)image, -minX, -minY, null);
        g2.dispose();
        return bi;
    }

    public static BufferedImage performDeskew(BufferedImage sourceImage) {
        BufferedImage outputImage = null;
        ImageDeskew deskew = new ImageDeskew(sourceImage);
        double imageSkewAngle = deskew.getSkewAngle();
        if (imageSkewAngle > 0.05 || imageSkewAngle < -0.05) {
            outputImage = ImageUtils.rotate(sourceImage, -imageSkewAngle, sourceImage.getWidth() / 2, sourceImage.getHeight() / 2);
            System.out.printf("Skew correction applied to image. Skew angle = %.2f", imageSkewAngle);
            System.out.println();
        } else {
            outputImage = sourceImage;
        }
        return outputImage;
    }

    public static void scaleImageFile(String src, float sfactor, String dest, String format) throws IOException {
        BufferedImage bdest = null;
        BufferedImage bsrc = ImageIO.read(new File(src));
        bdest = ImageUtils.scaleImage(bsrc, sfactor);
        ImageIO.write((RenderedImage)bdest, format, new File(dest));
    }

    public static BufferedImage scaleImage(BufferedImage bsrc, float sfactor) {
        int height = (int)((float)bsrc.getHeight() * sfactor);
        int width = (int)((float)bsrc.getWidth() * sfactor);
        BufferedImage bdest = new BufferedImage(width, height, 1);
        Graphics2D g = bdest.createGraphics();
        AffineTransform at = AffineTransform.getScaleInstance((double)width / (double)bsrc.getWidth(), (double)height / (double)bsrc.getHeight());
        g.drawRenderedImage(bsrc, at);
        return bdest;
    }

    static BufferedImage binarize(BufferedImage src_img, int white_tshld_value) {
        int grey_val = 0;
        int sh = src_img.getHeight();
        int sw = src_img.getWidth();
        BufferedImage bin_img = new BufferedImage(sw, sh, 2);
        for (int y = 0; y < sh; ++y) {
            for (int x = 0; x < sw; ++x) {
                int pixel;
                if (x == 285 && y == 71) {
                    x = 285;
                }
                pixel = (grey_val = ImageUtils.rgbToGrayScale(pixel = src_img.getRGB(x, y))) >= white_tshld_value ? WHITE_PIX_VALUE : BLACK_PIX_VALUE;
                bin_img.setRGB(x, y, pixel);
            }
        }
        return bin_img;
    }

    public static int rgbToGrayScale(int pix) {
        int r = pix >> 16 & 0xFF;
        int g = pix >> 8 & 0xFF;
        int b = pix & 0xFF;
        int Y = r * 306 + g * 601 + b * 117 >> 10;
        if (Y < 0) {
            Y = 0;
        } else if (Y > 255) {
            Y = 255;
        }
        return Y;
    }
}

