/*
 * Decompiled with CFR 0.152.
 */
package ocr;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ocr.ImageUtils;
import ocr.ocrgui;

public class DocImagePanel
extends JPanel {
    File ImageFile = null;
    BufferedImage DisplayedImg;
    ImageIcon OI;
    ImageIcon CurrII;
    JScrollPane jsp = null;
    JLabel JL = null;
    private int JSPKeyCode = 0;
    private int JSP_Width = -1;
    private int JSP_Height = -1;
    Graphics JSPG = null;
    private int LastX1 = -1;
    private int LastX2 = -1;
    private int LastY1 = -1;
    private int LastY2 = -1;
    private int LastLY1 = -1;
    private int LastLY2 = -1;
    private boolean ShiftkeyPressed = false;
    private boolean CtrlkeyPressed = false;
    private boolean Debug = false;
    private float scalefactor = 1.0f;
    private String Msg = null;

    public DocImagePanel() {
        this.initComponents();
        this.setSize(ocrgui.ImagePanelWidth, ocrgui.PanelHt);
        this.setPreferredSize(new Dimension(ocrgui.ImagePanelWidth, ocrgui.PanelHt));
        this.setVisible(true);
        this.OI = null;
        this.CurrII = null;
        this.JL = new JLabel(this.OI);
        this.jsp = new JScrollPane(this.JL);
        this.jsp.setSize(this.getPanelPrefSize());
        this.jsp.setAutoscrolls(true);
        this.jsp.setSize(ocrgui.ImagePanelWidth, ocrgui.PanelHt);
        this.jsp.setCursor(new Cursor(1));
        this.JSP_Width = this.jsp.getWidth();
        this.JSP_Height = this.jsp.getHeight() - 16;
        this.jsp.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                DocImagePanel.this.jspMouseEntered(evt);
            }
        });
        this.jsp.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                DocImagePanel.this.jspMouseMoved(evt);
            }
        });
        this.jsp.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DocImagePanel.this.jspMouseClicked(evt);
            }
        });
        this.jsp.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                DocImagePanel.this.jspKeyPressed(evt);
            }
        });
        this.jsp.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                DocImagePanel.this.jspKeyReleased(evt);
            }
        });
        this.add(this.jsp);
    }

    public void setDebug(boolean d) {
        this.Debug = d;
    }

    public void resizePanel(int w, int h) {
        this.jsp.setSize(this.getPanelCurrentSize());
    }

    public void openImageFile(String f) {
        try {
            this.ImageFile = new File(f);
            BufferedImage srcimg = ImageIO.read(this.ImageFile);
            this.DisplayedImg = ImageUtils.performDeskew(srcimg);
            this.CurrII = this.OI = new ImageIcon(this.DisplayedImg);
            this.JL.setIcon(this.OI);
        }
        catch (IOException ie) {
            this.Msg = "Error while deskewing image " + f + "...";
            System.out.println(this.Msg);
            JOptionPane.showMessageDialog(this, this.Msg, "Image DeSkew Error", 0);
        }
    }

    public void scaleDocImage(float factor) {
        Image img = this.OI.getImage();
        img = img.getScaledInstance((int)((float)img.getWidth(null) * factor), (int)((float)img.getHeight(null) * factor), 4);
        this.CurrII = new ImageIcon(img);
        this.JL.setIcon(this.CurrII);
        this.jsp.validate();
        this.jsp.repaint();
        this.LastX1 = -1;
        this.LastX2 = -1;
        this.LastY1 = -1;
        this.LastY2 = -1;
        this.LastLY1 = -1;
        this.LastLY2 = -1;
    }

    public void setScaleFactor(float s) {
        this.scalefactor = s;
    }

    public void binarizeImage(int wtshld, float factor) {
        try {
            if (this.ImageFile == null) {
                return;
            }
            BufferedImage bin_img = ImageUtils.binarize(ImageUtils.readImageFile(this.ImageFile), wtshld);
            Image img = bin_img.getScaledInstance((int)((float)bin_img.getWidth() * factor), (int)((float)bin_img.getHeight() * factor), 4);
            this.CurrII = new ImageIcon(img);
            this.JL.setIcon(this.CurrII);
            this.jsp.validate();
            this.jsp.repaint();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    private void jspMouseEntered(MouseEvent evt) {
        this.jsp.requestFocusInWindow();
        this.JSPG = this.jsp.getGraphics();
    }

    private void jspMouseClicked(MouseEvent evt) {
        if (this.JSPKeyCode == 0) {
            return;
        }
        switch (this.JSPKeyCode) {
            case 37: {
                if (this.LastX1 != -1) {
                    this.jsp.paintImmediately(this.LastX1, 1, 1, this.JSP_Height);
                }
                this.LastX1 = evt.getX();
                this.JSPG.drawLine(this.LastX1, 1, this.LastX1, this.JSP_Height);
                break;
            }
            case 39: {
                if (this.LastX2 != -1) {
                    this.jsp.paintImmediately(this.LastX2, 1, 1, this.JSP_Height);
                }
                this.LastX2 = evt.getX();
                this.JSPG.drawLine(this.LastX2, 1, this.LastX2, this.JSP_Height);
                break;
            }
            case 38: {
                if (this.ShiftkeyPressed) {
                    if (this.LastLY1 != -1) {
                        this.jsp.paintImmediately(1, this.LastLY1, this.JSP_Width, 1);
                    }
                    this.LastLY1 = evt.getY();
                    this.JSPG.drawLine(1, this.LastLY1, this.JSP_Width, this.LastLY1);
                    break;
                }
                if (this.LastY1 != -1) {
                    this.jsp.paintImmediately(1, this.LastY1, this.JSP_Width, 1);
                }
                this.LastY1 = evt.getY();
                this.JSPG.drawLine(1, this.LastY1, this.JSP_Width, this.LastY1);
                break;
            }
            case 40: {
                if (this.ShiftkeyPressed) {
                    if (this.LastLY2 != -1) {
                        this.jsp.paintImmediately(1, this.LastLY2, this.JSP_Width, 1);
                    }
                    this.LastLY2 = evt.getY();
                    this.JSPG.drawLine(1, this.LastLY2, this.JSP_Width, this.LastLY2);
                    break;
                }
                if (this.LastY2 != -1) {
                    this.jsp.paintImmediately(1, this.LastY2, this.JSP_Width, 1);
                }
                this.LastY2 = evt.getY();
                this.JSPG.drawLine(1, this.LastY2, this.JSP_Width, this.LastY2);
                break;
            }
        }
    }

    private void jspMouseMoved(MouseEvent evt) {
        if (this.JSPKeyCode != 71) {
            return;
        }
        int h_begin = this.jsp.getHorizontalScrollBar().getValue();
        int h_extent = this.jsp.getHorizontalScrollBar().getModel().getExtent();
        int v_begin = this.jsp.getVerticalScrollBar().getValue();
        int v_extent = this.jsp.getVerticalScrollBar().getModel().getExtent();
        int img_h_begin = h_extent > this.CurrII.getImage().getWidth(null) ? (this.CurrII.getImage().getWidth(null) - h_extent - 1) / 2 : 0;
        int img_v_begin = v_extent > this.CurrII.getImage().getHeight(null) ? (this.CurrII.getImage().getHeight(null) - v_extent - 1) / 2 : 0;
        int pixel_x = (int)((float)(h_begin + img_h_begin + evt.getX()) / this.scalefactor);
        int pixel_y = (int)((float)(v_begin + img_v_begin + evt.getY()) / this.scalefactor);
        String s = String.format("Grey Value at %d, %d is %d", pixel_x, pixel_y, ImageUtils.rgbToGrayScale(this.DisplayedImg.getRGB(pixel_x, pixel_y)));
        ocrgui.displayGreyValue(s);
    }

    private void jspKeyPressed(KeyEvent evt) {
        int keyc = evt.getKeyCode();
        switch (keyc) {
            case 37: {
                this.JSPKeyCode = 37;
                this.JSPG.setColor(Color.PINK);
                break;
            }
            case 39: {
                this.JSPKeyCode = 39;
                this.JSPG.setColor(Color.PINK);
                break;
            }
            case 38: {
                this.JSPKeyCode = 38;
                if (this.ShiftkeyPressed) {
                    this.JSPG.setColor(Color.GREEN);
                    break;
                }
                this.JSPG.setColor(Color.BLUE);
                break;
            }
            case 40: {
                this.JSPKeyCode = 40;
                if (this.ShiftkeyPressed) {
                    this.JSPG.setColor(Color.GREEN);
                    break;
                }
                this.JSPG.setColor(Color.BLUE);
                break;
            }
            case 16: {
                this.JSPKeyCode = 0;
                this.ShiftkeyPressed = true;
                break;
            }
            case 17: {
                this.JSPKeyCode = 0;
                this.CtrlkeyPressed = true;
                break;
            }
            case 71: {
                this.JSPKeyCode = 71;
                break;
            }
            default: {
                this.JSPKeyCode = 0;
            }
        }
        if (!this.CtrlkeyPressed || keyc != 79) {
            evt.consume();
        }
    }

    private void jspKeyReleased(KeyEvent evt) {
        this.JSPKeyCode = 0;
        if (evt.getKeyCode() == 16) {
            this.ShiftkeyPressed = false;
        } else if (evt.getKeyCode() == 17) {
            this.CtrlkeyPressed = false;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private Dimension getPanelPrefSize() {
        Dimension d = new Dimension();
        Insets insets = this.getInsets();
        d.width = this.getPreferredSize().width - insets.left - insets.right;
        d.height = this.getPreferredSize().height - insets.top - insets.bottom;
        return d;
    }

    private Dimension getPanelCurrentSize() {
        Dimension d = new Dimension();
        Insets insets = this.getInsets();
        d.width = this.getSize().width - insets.left - insets.right;
        d.height = this.getSize().height - insets.top - insets.bottom;
        return d;
    }

    private Cursor getHLineCursorForPanel(int width, int height) {
        BufferedImage bimage = new BufferedImage(width, height, 1);
        for (int i = 0; i < width; ++i) {
            bimage.setRGB(i, 0, -16711936);
        }
        Image im = Toolkit.getDefaultToolkit().createImage(bimage.getSource());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.createCustomCursor(im, new Point(0, 0), "BigCrossHair");
    }

    public int getUserHSpaceBetwTextBlk() {
        if (this.LastX1 == -1 || this.LastX2 == -1) {
            return 0;
        }
        return Math.max(Math.abs(this.LastX1 - this.LastX2), 0);
    }

    public int getUserVSpaceBetwTextBlk() {
        if (this.LastY1 == -1 || this.LastY2 == -1) {
            return 0;
        }
        return Math.max(Math.abs(this.LastY1 - this.LastY2), 0);
    }

    public int getUserLetterheight() {
        if (this.LastLY1 == -1 || this.LastLY2 == -1) {
            return 0;
        }
        return Math.max(Math.abs(this.LastLY1 - this.LastLY2), 0);
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 255), 4));
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(10, 15));
        this.setPreferredSize(new Dimension(400, 460));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 392, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 452, Short.MAX_VALUE));
    }
}

