/*
 * Decompiled with CFR 0.152.
 */
package ocr;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import ocr.ImageDeskew;

public class ImageUtils {
    public static int BLACK_PIX_VALUE = -16777216;
    public static int WHITE_PIX_VALUE = -1;

    public static BufferedImage readImageFile(File file) {
        return ImageIO.read(file);
    }

    public static boolean isBlack(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage.getType() == 12) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            int n3 = writableRaster.getSample(n, n2, 0);
            return n3 == 0;
        }
        int n4 = 140;
        return ImageUtils.isBlack(bufferedImage, n, n2, n4);
    }

    public static boolean isBlack(BufferedImage bufferedImage, int n, int n2, int n3) {
        double d = 0.0;
        if (n < 0 || n2 < 0 || n > bufferedImage.getWidth() || n2 > bufferedImage.getHeight()) {
            return false;
        }
        try {
            int n4 = bufferedImage.getRGB(n, n2);
            int n5 = n4 >> 16 & 0xFF;
            int n6 = n4 >> 8 & 0xFF;
            int n7 = n4 >> 0 & 0xFF;
            d = (double)n5 * 0.299 + (double)n6 * 0.587 + (double)n7 * 0.114;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d < (double)n3;
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, double d, int n, int n2) {
        int n3 = bufferedImage.getWidth(null);
        int n4 = bufferedImage.getHeight(null);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int[] nArray = new int[]{0, 0, n3, 0, n3, n4, 0, n4};
        double d2 = Math.toRadians(d);
        for (int i = 0; i < nArray.length; i += 2) {
            int n9 = (int)(Math.cos(d2) * (double)(nArray[i] - n) - Math.sin(d2) * (double)(nArray[i + 1] - n2) + (double)n);
            int n10 = (int)(Math.sin(d2) * (double)(nArray[i] - n) + Math.cos(d2) * (double)(nArray[i + 1] - n2) + (double)n2);
            if (n9 > n6) {
                n6 = n9;
            }
            if (n9 < n8) {
                n8 = n9;
            }
            if (n10 > n5) {
                n5 = n10;
            }
            if (n10 >= n7) continue;
            n7 = n10;
        }
        n -= n8;
        n2 -= n7;
        BufferedImage bufferedImage2 = new BufferedImage(n6 - n8, n5 - n7, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setBackground(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d2, n, n2);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)bufferedImage, -n8, -n7, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static byte[][] rotate(byte[][] byArray, int n, int n2, double d) {
        double d2 = Math.toRadians(-d);
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = 0.5 * (double)(n - 1);
        double d6 = 0.5 * (double)(n2 - 1);
        byte[][] byArray2 = new byte[n2][n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d7 = (double)j - d5;
                double d8 = (double)i - d6;
                int n3 = (int)(d7 * d4 - d8 * d3 + d5);
                int n4 = (int)(d7 * d3 + d8 * d4 + d6);
                if (n3 < 0 || n3 >= n || n4 < 0 || n4 >= n2) continue;
                byArray2[n4][n3] = byArray[i][j];
            }
        }
        return byArray2;
    }

    public static BufferedImage performDeskew(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        ImageDeskew imageDeskew = new ImageDeskew(bufferedImage);
        double d = imageDeskew.getSkewAngle();
        if (d > 0.05 || d < -0.05) {
            bufferedImage2 = ImageUtils.rotate(bufferedImage, -d, bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2);
            System.out.printf("Skew correction applied to image. Skew angle = %.2f", d);
            System.out.println();
        } else {
            bufferedImage2 = bufferedImage;
        }
        return bufferedImage2;
    }

    public static byte[][] performDeskew(byte[][] byArray, int n, int n2) {
        byte[][] byArray2 = null;
        ImageDeskew imageDeskew = new ImageDeskew(byArray, n, n2);
        double d = imageDeskew.getSkewAngle();
        if (d > 0.05 || d < -0.05) {
            byArray2 = ImageUtils.rotate(byArray, n, n2, d);
            System.out.printf("Skew correction applied to image. Skew angle = %.2f\n", d);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static void scaleImageFile(String string, float f, String string2, String string3) {
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = ImageIO.read(new File(string));
        bufferedImage = ImageUtils.scaleImage(bufferedImage2, f);
        ImageIO.write((RenderedImage)bufferedImage, string3, new File(string2));
    }

    public static BufferedImage scaleImage(BufferedImage bufferedImage, float f) {
        if ((double)f < 0.0) {
            return bufferedImage;
        }
        Image image = bufferedImage.getScaledInstance((int)((float)bufferedImage.getWidth() * f), (int)((float)bufferedImage.getHeight() * f), 4);
        return ImageUtils.toBufferedImage(image);
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = ImageUtils.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    static BufferedImage a(BufferedImage bufferedImage, int n) {
        int n2 = 0;
        int n3 = bufferedImage.getHeight();
        int n4 = bufferedImage.getWidth();
        BufferedImage bufferedImage2 = new BufferedImage(n4, n3, 2);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n5 = bufferedImage.getRGB(j, i);
                n2 = ImageUtils.rgbToGrayScale(n5);
                n5 = n2 >= n ? WHITE_PIX_VALUE : BLACK_PIX_VALUE;
                bufferedImage2.setRGB(j, i, n5);
            }
        }
        return bufferedImage2;
    }

    public static int rgbToGrayScale(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = n2 * 306 + n3 * 601 + n4 * 117 >> 10;
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 > 255) {
            n5 = 255;
        }
        return n5;
    }
}

